<?php defined('PF_VERSION') OR exit('Access denied'); ?>
<?php



class Pf_Galleries {
    protected $db;
    protected $v;
    function __construct() {
        $this->db   =   Pf::database();
        $this->v    =   Pf::validator();
    }
    public function validate($array) {
        $rules = array(
                "gallery_name" => "required|max_len,255",
                "gallery_description" => "max_len,500",
            );
        $array  =   $this->v->sanitize($array);
        $this->v->validation_rules($rules);
        $validate   =  $this->v->run($array);
        if($validate===FALSE)
            return $this->v->get_readable_errors(false);
        else
        {   
            return TRUE;
        }
    }
    public function get_galleries($clause='', $array_clause=array(), $col='*') {
        if(!empty($clause))
            $this->db->select($col,'pf_galleries',$clause, $array_clause);
        else
            $this->db->select($col,'pf_galleries');
        return $this->db->fetch_assoc_all();
    }
    public function set_galleries($id, $array) {
        if(!empty($id))
            $this->db->update('pf_galleries',$array, "`id`=?",array($id));
        else
        {
            $this->db->insert('pf_galleries',$array);
            $id     =   $this->db->insert_id();
            return $id;
        }
    }
    public function delete_gallery($id) {
        if(!empty($id)){
            $this->db->delete('pf_galleries',"`id`=?",array($id));
        }
    }
    public function form_name($value) {
        echo form_input('gallery_name',$value);
    }
    public function form_desc($value) {
        echo "<textarea name='gallery_description' class='form-control' >$value</textarea>";
    }
    public function form_status($tf) {
        echo form_checkbox('gallery_status',1,$tf);
    }
    public function set_action($action, $id) {
        switch ($action) {
            case 'publish':
               $this->db->update('pf_galleries',array("gallery_status"=>1), "`id`=?",array($id));
                break;
            case 'unpublish':
               $this->db->update('pf_galleries',array("gallery_status"=>0), "`id`=?",array($id));
                break;
            case 'delete':
                 $this->delete_gallery($id);
                break;
        }
    }
    public function filter_public($array) {
        for ($i=0;$i<count($array);$i++){
            if($array[$i]['gallery_status']!='1')
            {
                  unset($array[$i]);
            }
              
        }
        return $array;
    }
    public function add_views($id) {
        $this->db->select('gallery_views','pf_galleries',"`id`= ? ",array($id));
        $result     =   $this->db->fetch_assoc_all();
        $current    =   !empty($result[0]['gallery_views'])?$result[0]['gallery_views']:0;
        $this->db->update('pf_galleries',array('gallery_views'=>($current+1)),"`id`=?",array($id));
        return  $current+1;
    }
}
